
package org.blufin.sdk.embedded.dto.app;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("user_permission")
public class EmbeddedUserPermission extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, extra = "1000", flags = {DataTypeFlag.AUTO_INCREMENT, DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "user.id")
    private Integer userId;
    @Override
    @JsonIgnore
    public Integer getParentId() {
        return getUserId();
    }
}
