
package org.blufin.sdk.embedded.dto.common;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ImplementsObject;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.annotations.helper.Relation;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("account")
public class EmbeddedAccount extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, extra = "1000", flags = {DataTypeFlag.AUTO_INCREMENT, DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.BOOLEAN, extra = "false")
    private Boolean archived;
    @Implements(value = DataType.BOOLEAN, extra = "false")
    private Boolean suspended;
    @Implements(value = DataType.BOOLEAN, extra = "true")
    private Boolean cronEnabled;
    @Implements(value = DataType.VARCHAR, extra = "64", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String accountName;
    @Implements(value = DataType.VARCHAR, extra = "128")
    private String accountDisplayName;
    @Implements(DataType.INT)
    private Integer dbId;
    @Implements(DataType.ENUM_SYSTEM)
    private TimeZone timeZone;
    @ImplementsObject(value = "account_permission", relation = Relation.ONE_TO_ONE)
    private EmbeddedAccountPermission accountPermission;
}
