
package org.blufin.sdk.embedded.dto.common;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
@Data
@ParsedByRuby
@Embedded("account_permission")
public class EmbeddedAccountPermission extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, extra = "1000", flags = {DataTypeFlag.AUTO_INCREMENT, DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "account.id")
    private Integer accountId;
    @Override
    @JsonIgnore
    public Integer getParentId() {
        return getAccountId();
    }
}
