
package org.blufin.sdk.embedded.dto.common;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("cron")
public class EmbeddedCron extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.BOOLEAN, extra = "false")
    private Boolean active;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String cronType;
    @Implements(value = DataType.VARCHAR, extra = "256")
    private String scheduleMinute;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String scheduleHour;
    @Implements(value = DataType.VARCHAR, extra = "128")
    private String scheduleDay;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String scheduleMonth;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String scheduleDayOfWeek;
}
