
package org.blufin.sdk.embedded.dto.common;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ImplementsObject;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.annotations.helper.Relation;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("third_party_application")
public class EmbeddedThirdPartyApplication extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.VARCHAR, extra = "45", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String hash;
    @Implements(value = DataType.INT, fkey = "third_party_developer.id")
    private Integer thirdPartyDeveloperId;
    @ImplementsObject(value = "third_party_application_permission", relation = Relation.ONE_TO_ONE)
    private EmbeddedThirdPartyApplicationPermission thirdPartyApplicationPermission;
}
