
package org.blufin.sdk.embedded.dto.common;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("third_party_application_permission")
public class EmbeddedThirdPartyApplicationPermission extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "third_party_application.id")
    private Integer thirdPartyApplicationId;
    @Override
    @JsonIgnore
    public Integer getParentId() {
        return getThirdPartyApplicationId();
    }
}
