
package org.blufin.sdk.embedded.dto.config;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("db")
public class EmbeddedDb extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, flags = {DataTypeFlag.NULLABLE}, fkey = "project.id")
    private Integer projectId;
    @Implements(value = DataType.VARCHAR, extra = "32", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String dbName;
    @Implements(value = DataType.VARCHAR, extra = "255")
    private String host;
    @Implements(value = DataType.TEXT)
    private String user;
    @Implements(value = DataType.TEXT)
    private String password;
    @Implements(value = DataType.ENUM_SYSTEM, flags = {DataTypeFlag.INDEX})
    private Environment environment;
    @Implements(value = DataType.ENUM_SYSTEM)
    private SchemaType schemaType;
    @Implements(value = DataType.VARCHAR, extra = "255")
    private String jdbcUrl;
}
