
package org.blufin.sdk.embedded.dto.config;
import lombok.Data;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ImplementsObject;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.annotations.helper.Relation;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import java.util.List;
@Data
@ParsedByRuby
@Embedded("db_configuration")
public class EmbeddedDbConfiguration extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.VARCHAR, extra = "32", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String dbConfigurationName;
    @Implements(DataType.INT)
    private Integer poolMaxSize;
    @ImplementsObject(value = "db_configuration_property", relation = Relation.ONE_TO_MANY)
    private List<EmbeddedDbConfigurationProperty> dbConfigurationPropertyList;
}
