
package org.blufin.sdk.embedded.dto.config;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("db_configuration_property")
public class EmbeddedDbConfigurationProperty extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "db_configuration.id")
    private Integer dbConfigurationId;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String key;
    @Implements(value = DataType.VARCHAR, extra = "128")
    private String value;
}
