
package org.blufin.sdk.embedded.dto.config;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ImplementsObject;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.annotations.helper.Relation;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.base.enums.Environment;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("profile")
public class EmbeddedProfile extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "project.id")
    private Integer projectId;
    @Implements(value = DataType.VARCHAR, extra = "32", flags = {DataTypeFlag.INDEX})
    private String profileName;
    @Implements(value = DataType.ENUM_SYSTEM, flags = {DataTypeFlag.INDEX})
    private Environment environment;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String timezone;
    @Implements(value = DataType.VARCHAR, extra = "255")
    private String messageQueueHost;
    @Implements(value = DataType.VARCHAR, extra = "255")
    private String slackLogUrl;
    @Implements(value = DataType.VARCHAR, extra = "255")
    private String slackErrorUrl;
    @Implements(value = DataType.TEXT)
    private String authorizationHeader;
    @ImplementsObject(value = "profile_api", relation = Relation.ONE_TO_ONE)
    private EmbeddedProfileApi profileApi;
    @ImplementsObject(value = "profile_cron", relation = Relation.ONE_TO_ONE)
    private EmbeddedProfileCron profileCron;
    @ImplementsObject(value = "profile_worker", relation = Relation.ONE_TO_ONE)
    private EmbeddedProfileWorker profileWorker;
}
