
package org.blufin.sdk.embedded.dto.config;
import org.blufin.base.annotations.Embedded;
import org.blufin.base.annotations.Implements;
import org.blufin.base.annotations.ParsedByRuby;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.DataTypeFlag;
import org.blufin.sdk.base.PersistentDtoEmbedded;
import lombok.Data;
@Data
@ParsedByRuby
@Embedded("project")
public class EmbeddedProject extends PersistentDtoEmbedded {
    @Implements(value = DataType.INT_AUTO, flags = {DataTypeFlag.PRIMARY_KEY})
    private Integer id;
    @Implements(value = DataType.INT, fkey = "client.id")
    private Integer clientId;
    @Implements(value = DataType.VARCHAR, extra = "64", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String projectName;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String projectNamePascalCase;
    @Implements(value = DataType.VARCHAR, extra = "128")
    private String projectTitle;
    @Implements(value = DataType.VARCHAR, extra = "128")
    private String domain;
    @Implements(value = DataType.VARCHAR, extra = "8", flags = {DataTypeFlag.INDEX, DataTypeFlag.UNIQUE})
    private String alias;
    @Implements(value = DataType.VARCHAR, extra = "12")
    private String portRange;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String encryptionKey;
    @Implements(value = DataType.VARCHAR, extra = "64")
    private String encryptionIv;
}
