
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import java.lang.reflect.InvocationTargetException;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedAccountMapper extends AbstractMapperEmbedded<EmbeddedAccount> {
    @Getter
    private static final EmbeddedAccountMapper instance = new EmbeddedAccountMapper();
    private EmbeddedAccountMapper() {}
    @Override
    public EmbeddedAccount map(Object account) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedAccount embeddedAccount = new EmbeddedAccount();
        embeddedAccount.setId((Integer) account.getClass().getMethod("getId").invoke(account));
        embeddedAccount.setArchived((Boolean) account.getClass().getMethod("isArchived").invoke(account));
        embeddedAccount.setSuspended((Boolean) account.getClass().getMethod("isSuspended").invoke(account));
        embeddedAccount.setCronEnabled((Boolean) account.getClass().getMethod("isCronEnabled").invoke(account));
        embeddedAccount.setAccountName((String) account.getClass().getMethod("getAccountName").invoke(account));
        embeddedAccount.setAccountDisplayName((String) account.getClass().getMethod("getAccountDisplayName").invoke(account));
        embeddedAccount.setDbId((Integer) account.getClass().getMethod("getDbId").invoke(account));
        embeddedAccount.setTimeZone((TimeZone) account.getClass().getMethod("getTimeZone").invoke(account));
        embeddedAccount.setAccountPermission(mapObject(account, "getAccountPermission", EmbeddedAccountPermissionMapper.getInstance()));
        return embeddedAccount;
    }
}
