
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfiguration;
import java.lang.reflect.InvocationTargetException;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedDbConfigurationMapper extends AbstractMapperEmbedded<EmbeddedDbConfiguration> {
    @Getter
    private static final EmbeddedDbConfigurationMapper instance = new EmbeddedDbConfigurationMapper();
    private EmbeddedDbConfigurationMapper() {}
    @Override
    public EmbeddedDbConfiguration map(Object dbConfiguration) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedDbConfiguration embeddedDbConfiguration = new EmbeddedDbConfiguration();
        embeddedDbConfiguration.setId((Integer) dbConfiguration.getClass().getMethod("getId").invoke(dbConfiguration));
        embeddedDbConfiguration.setDbConfigurationName((String) dbConfiguration.getClass().getMethod("getDbConfigurationName").invoke(dbConfiguration));
        embeddedDbConfiguration.setPoolMaxSize((Integer) dbConfiguration.getClass().getMethod("getPoolMaxSize").invoke(dbConfiguration));
        embeddedDbConfiguration.setDbConfigurationPropertyList(mapList(dbConfiguration, "getDbConfigurationPropertyList", EmbeddedDbConfigurationPropertyMapper.getInstance()));
        return embeddedDbConfiguration;
    }
}
