
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.config.EmbeddedDb;
import java.lang.reflect.InvocationTargetException;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedDbMapper extends AbstractMapperEmbedded<EmbeddedDb> {
    @Getter
    private static final EmbeddedDbMapper instance = new EmbeddedDbMapper();
    private EmbeddedDbMapper() {}
    @Override
    public EmbeddedDb map(Object db) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedDb embeddedDb = new EmbeddedDb();
        embeddedDb.setId((Integer) db.getClass().getMethod("getId").invoke(db));
        embeddedDb.setProjectId((Integer) db.getClass().getMethod("getProjectId").invoke(db));
        embeddedDb.setDbName((String) db.getClass().getMethod("getDbName").invoke(db));
        embeddedDb.setHost((String) db.getClass().getMethod("getHost").invoke(db));
        embeddedDb.setUser((String) db.getClass().getMethod("getUser").invoke(db));
        embeddedDb.setPassword((String) db.getClass().getMethod("getPassword").invoke(db));
        embeddedDb.setEnvironment((Environment) db.getClass().getMethod("getEnvironment").invoke(db));
        embeddedDb.setSchemaType((SchemaType) db.getClass().getMethod("getSchemaType").invoke(db));
        embeddedDb.setJdbcUrl((String) db.getClass().getMethod("getJdbcUrl").invoke(db));
        return embeddedDb;
    }
}
