
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.Environment;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfile;
import java.lang.reflect.InvocationTargetException;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedProfileMapper extends AbstractMapperEmbedded<EmbeddedProfile> {
    @Getter
    private static final EmbeddedProfileMapper instance = new EmbeddedProfileMapper();
    private EmbeddedProfileMapper() {}
    @Override
    public EmbeddedProfile map(Object profile) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedProfile embeddedProfile = new EmbeddedProfile();
        embeddedProfile.setId((Integer) profile.getClass().getMethod("getId").invoke(profile));
        embeddedProfile.setProjectId((Integer) profile.getClass().getMethod("getProjectId").invoke(profile));
        embeddedProfile.setProfileName((String) profile.getClass().getMethod("getProfileName").invoke(profile));
        embeddedProfile.setEnvironment((Environment) profile.getClass().getMethod("getEnvironment").invoke(profile));
        embeddedProfile.setTimezone((String) profile.getClass().getMethod("getTimezone").invoke(profile));
        embeddedProfile.setMessageQueueHost((String) profile.getClass().getMethod("getMessageQueueHost").invoke(profile));
        embeddedProfile.setSlackLogUrl((String) profile.getClass().getMethod("getSlackLogUrl").invoke(profile));
        embeddedProfile.setSlackErrorUrl((String) profile.getClass().getMethod("getSlackErrorUrl").invoke(profile));
        embeddedProfile.setAuthorizationHeader((String) profile.getClass().getMethod("getAuthorizationHeader").invoke(profile));
        embeddedProfile.setProfileApi(mapObject(profile, "getProfileApi", EmbeddedProfileApiMapper.getInstance()));
        embeddedProfile.setProfileCron(mapObject(profile, "getProfileCron", EmbeddedProfileCronMapper.getInstance()));
        embeddedProfile.setProfileWorker(mapObject(profile, "getProfileWorker", EmbeddedProfileWorkerMapper.getInstance()));
        return embeddedProfile;
    }
}
