
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.config.EmbeddedProject;
import java.lang.reflect.InvocationTargetException;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedProjectMapper extends AbstractMapperEmbedded<EmbeddedProject> {
    @Getter
    private static final EmbeddedProjectMapper instance = new EmbeddedProjectMapper();
    private EmbeddedProjectMapper() {}
    @Override
    public EmbeddedProject map(Object project) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedProject embeddedProject = new EmbeddedProject();
        embeddedProject.setId((Integer) project.getClass().getMethod("getId").invoke(project));
        embeddedProject.setClientId((Integer) project.getClass().getMethod("getClientId").invoke(project));
        embeddedProject.setProjectName((String) project.getClass().getMethod("getProjectName").invoke(project));
        embeddedProject.setProjectNamePascalCase((String) project.getClass().getMethod("getProjectNamePascalCase").invoke(project));
        embeddedProject.setProjectTitle((String) project.getClass().getMethod("getProjectTitle").invoke(project));
        embeddedProject.setDomain((String) project.getClass().getMethod("getDomain").invoke(project));
        embeddedProject.setAlias((String) project.getClass().getMethod("getAlias").invoke(project));
        embeddedProject.setPortRange((String) project.getClass().getMethod("getPortRange").invoke(project));
        embeddedProject.setEncryptionKey((String) project.getClass().getMethod("getEncryptionKey").invoke(project));
        embeddedProject.setEncryptionIv((String) project.getClass().getMethod("getEncryptionIv").invoke(project));
        return embeddedProject;
    }
}
