
package org.blufin.sdk.embedded.mapper;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractMapperEmbedded;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedUserMapper extends AbstractMapperEmbedded<EmbeddedUser> {
    @Getter
    private static final EmbeddedUserMapper instance = new EmbeddedUserMapper();
    private EmbeddedUserMapper() {}
    @Override
    public EmbeddedUser map(Object user) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EmbeddedUser embeddedUser = new EmbeddedUser();
        embeddedUser.setId((Integer) user.getClass().getMethod("getId").invoke(user));
        embeddedUser.setArchived((Boolean) user.getClass().getMethod("isArchived").invoke(user));
        embeddedUser.setSuspended((Boolean) user.getClass().getMethod("isSuspended").invoke(user));
        embeddedUser.setEmail((String) user.getClass().getMethod("getEmail").invoke(user));
        embeddedUser.setPasswordHash((String) user.getClass().getMethod("getPasswordHash").invoke(user));
        embeddedUser.setCreatedDate((LocalDate) user.getClass().getMethod("getCreatedDate").invoke(user));
        embeddedUser.setTimeZone((TimeZone) user.getClass().getMethod("getTimeZone").invoke(user));
        embeddedUser.setUserPermission(mapObject(user, "getUserPermission", EmbeddedUserPermissionMapper.getInstance()));
        return embeddedUser;
    }
}
