
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedAccountMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedAccountMetaData instance = new EmbeddedAccountMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_ARCHIVED = "archived";
    public static final String FIELD_SUSPENDED = "suspended";
    public static final String FIELD_CRON_ENABLED = "cron_enabled";
    public static final String FIELD_ACCOUNT_NAME = "account_name";
    public static final String FIELD_ACCOUNT_DISPLAY_NAME = "account_display_name";
    public static final String FIELD_DB_ID = "db_id";
    public static final String FIELD_TIME_ZONE = "time_zone";
    public static final String FIELD_ACCOUNT_PERMISSION = "account_permission";
    private EmbeddedAccountMetaData() {
        super(SchemaType.COMMON, "account", null, Arrays.asList("account", "account/permission"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_AUTO_INCREMENT, FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_ARCHIVED, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_SUSPENDED, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_CRON_ENABLED, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_ACCOUNT_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_ACCOUNT_DISPLAY_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 128);
        }});
        metaData.put(FIELD_DB_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
        }});
        metaData.put(FIELD_TIME_ZONE, new HashMap<String, Object>() {{
            put(TYPE, DataType.ENUM_SYSTEM);
            put(MAX_LENGTH, 3);
            put(ENUM_NAME, "TimeZone");
            put(ENUM_VALUES, getEnumValues(TimeZone.values()));
        }});
        metaData.put(FIELD_ACCOUNT_PERMISSION, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        switch (nestedTable) {
            case "account_permission":
                return EmbeddedAccountPermissionMetaData.getInstance();
            default:
                throw new RuntimeException(MessageFormat.format("EmbeddedEmbeddedAccountMetaData doesn''t have nested metadata for table: {0}", nestedTable));
        }
    }
}
