
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedClientMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedClientMetaData instance = new EmbeddedClientMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_CLIENT_NAME = "client_name";
    private EmbeddedClientMetaData() {
        super(SchemaType.CONFIG, "client", null, Arrays.asList("client"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_CLIENT_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 64);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedClientMetaData. This method should never be called manually.");
    }
}
