
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedCronMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedCronMetaData instance = new EmbeddedCronMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_CRON_TYPE = "cron_type";
    public static final String FIELD_SCHEDULE_MINUTE = "schedule_minute";
    public static final String FIELD_SCHEDULE_HOUR = "schedule_hour";
    public static final String FIELD_SCHEDULE_DAY = "schedule_day";
    public static final String FIELD_SCHEDULE_MONTH = "schedule_month";
    public static final String FIELD_SCHEDULE_DAY_OF_WEEK = "schedule_day_of_week";
    private EmbeddedCronMetaData() {
        super(SchemaType.COMMON, "cron", null, Arrays.asList("cron"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_ACTIVE, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_CRON_TYPE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_SCHEDULE_MINUTE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 256);
        }});
        metaData.put(FIELD_SCHEDULE_HOUR, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_SCHEDULE_DAY, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 128);
        }});
        metaData.put(FIELD_SCHEDULE_MONTH, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_SCHEDULE_DAY_OF_WEEK, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedCronMetaData. This method should never be called manually.");
    }
}
