
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedDbConfigurationMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedDbConfigurationMetaData instance = new EmbeddedDbConfigurationMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_DB_CONFIGURATION_NAME = "db_configuration_name";
    public static final String FIELD_POOL_MAX_SIZE = "pool_max_size";
    public static final String FIELD__LIST = "_list";
    private EmbeddedDbConfigurationMetaData() {
        super(SchemaType.CONFIG, "db_configuration", null, Arrays.asList("db_configuration", "db_configuration/property"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_DB_CONFIGURATION_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 32);
        }});
        metaData.put(FIELD_POOL_MAX_SIZE, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
        }});
        metaData.put(FIELD__LIST, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT_LIST);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        switch (nestedTable) {
            case "db_configuration_property":
                return EmbeddedDbConfigurationPropertyMetaData.getInstance();
            default:
                throw new RuntimeException(MessageFormat.format("EmbeddedEmbeddedDbConfigurationMetaData doesn''t have nested metadata for table: {0}", nestedTable));
        }
    }
}
