
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedDbConfigurationPropertyMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedDbConfigurationPropertyMetaData instance = new EmbeddedDbConfigurationPropertyMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_DB_CONFIGURATION_ID = "db_configuration_id";
    public static final String FIELD_KEY = "key";
    public static final String FIELD_VALUE = "value";
    private EmbeddedDbConfigurationPropertyMetaData() {
        super(SchemaType.CONFIG, "db_configuration_property", "db_configuration", Arrays.asList("db_configuration_property"), DataType.OBJECT_LIST);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_DB_CONFIGURATION_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.db_configuration.id");
            put(CHILD_OF, "db_configuration");
        }});
        metaData.put(FIELD_KEY, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_VALUE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 128);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedDbConfigurationPropertyMetaData. This method should never be called manually.");
    }
}
