
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedDbMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedDbMetaData instance = new EmbeddedDbMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_PROJECT_ID = "project_id";
    public static final String FIELD_DB_NAME = "db_name";
    public static final String FIELD_HOST = "host";
    public static final String FIELD_USER = "user";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_ENVIRONMENT = "environment";
    public static final String FIELD_SCHEMA_TYPE = "schema_type";
    public static final String FIELD_JDBC_URL = "jdbc_url";
    private EmbeddedDbMetaData() {
        super(SchemaType.CONFIG, "db", null, Arrays.asList("db"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_PROJECT_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FLAG, Arrays.asList(FLAG_NULLABLE));
            put(FKEY, "config.project.id");
        }});
        metaData.put(FIELD_DB_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 32);
        }});
        metaData.put(FIELD_HOST, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_USER, new HashMap<String, Object>() {{
            put(TYPE, DataType.TEXT);
        }});
        metaData.put(FIELD_PASSWORD, new HashMap<String, Object>() {{
            put(TYPE, DataType.TEXT);
        }});
        metaData.put(FIELD_ENVIRONMENT, new HashMap<String, Object>() {{
            put(TYPE, DataType.ENUM_SYSTEM);
            put(FLAG, Arrays.asList(FLAG_INDEX));
            put(MAX_LENGTH, 11);
            put(ENUM_NAME, "Environment");
            put(ENUM_VALUES, getEnumValues(Environment.values()));
        }});
        metaData.put(FIELD_SCHEMA_TYPE, new HashMap<String, Object>() {{
            put(TYPE, DataType.ENUM_SYSTEM);
            put(MAX_LENGTH, 6);
            put(ENUM_NAME, "SchemaType");
            put(ENUM_VALUES, getEnumValues(SchemaType.values()));
        }});
        metaData.put(FIELD_JDBC_URL, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 255);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedDbMetaData. This method should never be called manually.");
    }
}
