
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedProfileApiMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedProfileApiMetaData instance = new EmbeddedProfileApiMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_PROFILE_ID = "profile_id";
    public static final String FIELD_COMMON_DB_ID = "common_db_id";
    public static final String FIELD_COMMON_DB_CONFIGURATION_ID = "common_db_configuration_id";
    private EmbeddedProfileApiMetaData() {
        super(SchemaType.CONFIG, "profile_api", "profile", Arrays.asList("profile_api"), DataType.OBJECT);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_PROFILE_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.profile.id");
            put(CHILD_OF, "profile");
        }});
        metaData.put(FIELD_COMMON_DB_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.db.id");
        }});
        metaData.put(FIELD_COMMON_DB_CONFIGURATION_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.db_configuration.id");
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedProfileApiMetaData. This method should never be called manually.");
    }
}
