
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedProfileMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedProfileMetaData instance = new EmbeddedProfileMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_PROJECT_ID = "project_id";
    public static final String FIELD_PROFILE_NAME = "profile_name";
    public static final String FIELD_ENVIRONMENT = "environment";
    public static final String FIELD_TIMEZONE = "timezone";
    public static final String FIELD_MESSAGE_QUEUE_HOST = "message_queue_host";
    public static final String FIELD_SLACK_LOG_URL = "slack_log_url";
    public static final String FIELD_SLACK_ERROR_URL = "slack_error_url";
    public static final String FIELD_AUTHORIZATION_HEADER = "authorization_header";
    public static final String FIELD_PROFILE_API = "profile_api";
    public static final String FIELD_PROFILE_CRON = "profile_cron";
    public static final String FIELD_PROFILE_WORKER = "profile_worker";
    private EmbeddedProfileMetaData() {
        super(SchemaType.CONFIG, "profile", null, Arrays.asList("profile", "profile/api", "profile/cron", "profile/worker"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_PROJECT_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.project.id");
        }});
        metaData.put(FIELD_PROFILE_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX));
            put(MAX_LENGTH, 32);
        }});
        metaData.put(FIELD_ENVIRONMENT, new HashMap<String, Object>() {{
            put(TYPE, DataType.ENUM_SYSTEM);
            put(FLAG, Arrays.asList(FLAG_INDEX));
            put(MAX_LENGTH, 11);
            put(ENUM_NAME, "Environment");
            put(ENUM_VALUES, getEnumValues(Environment.values()));
        }});
        metaData.put(FIELD_TIMEZONE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_MESSAGE_QUEUE_HOST, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_SLACK_LOG_URL, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_SLACK_ERROR_URL, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_AUTHORIZATION_HEADER, new HashMap<String, Object>() {{
            put(TYPE, DataType.TEXT);
        }});
        metaData.put(FIELD_PROFILE_API, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
        metaData.put(FIELD_PROFILE_CRON, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
        metaData.put(FIELD_PROFILE_WORKER, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        switch (nestedTable) {
            case "profile_api":
                return EmbeddedProfileApiMetaData.getInstance();
            case "profile_cron":
                return EmbeddedProfileCronMetaData.getInstance();
            case "profile_worker":
                return EmbeddedProfileWorkerMetaData.getInstance();
            default:
                throw new RuntimeException(MessageFormat.format("EmbeddedEmbeddedProfileMetaData doesn''t have nested metadata for table: {0}", nestedTable));
        }
    }
}
