
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedProjectMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedProjectMetaData instance = new EmbeddedProjectMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_CLIENT_ID = "client_id";
    public static final String FIELD_PROJECT_NAME = "project_name";
    public static final String FIELD_PROJECT_NAME_PASCAL_CASE = "project_name_pascal_case";
    public static final String FIELD_PROJECT_TITLE = "project_title";
    public static final String FIELD_DOMAIN = "domain";
    public static final String FIELD_ALIAS = "alias";
    public static final String FIELD_PORT_RANGE = "port_range";
    public static final String FIELD_ENCRYPTION_KEY = "encryption_key";
    public static final String FIELD_ENCRYPTION_IV = "encryption_iv";
    private EmbeddedProjectMetaData() {
        super(SchemaType.CONFIG, "project", null, Arrays.asList("project"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_CLIENT_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "config.client.id");
        }});
        metaData.put(FIELD_PROJECT_NAME, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_PROJECT_NAME_PASCAL_CASE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_PROJECT_TITLE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 128);
        }});
        metaData.put(FIELD_DOMAIN, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 128);
        }});
        metaData.put(FIELD_ALIAS, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 8);
        }});
        metaData.put(FIELD_PORT_RANGE, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 12);
        }});
        metaData.put(FIELD_ENCRYPTION_KEY, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
        metaData.put(FIELD_ENCRYPTION_IV, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(MAX_LENGTH, 64);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        throw new RuntimeException("Nested metadata not available for EmbeddedEmbeddedProjectMetaData. This method should never be called manually.");
    }
}
