
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedThirdPartyApplicationMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedThirdPartyApplicationMetaData instance = new EmbeddedThirdPartyApplicationMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_HASH = "hash";
    public static final String FIELD_THIRD_PARTY_DEVELOPER_ID = "third_party_developer_id";
    public static final String FIELD_THIRD_PARTY_APPLICATION_PERMISSION = "third_party_application_permission";
    private EmbeddedThirdPartyApplicationMetaData() {
        super(SchemaType.COMMON, "third_party_application", null, Arrays.asList("third_party_application", "third_party_application/permission"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_HASH, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 45);
        }});
        metaData.put(FIELD_THIRD_PARTY_DEVELOPER_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT);
            put(FKEY, "common.third_party_developer.id");
        }});
        metaData.put(FIELD_THIRD_PARTY_APPLICATION_PERMISSION, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        switch (nestedTable) {
            case "third_party_application_permission":
                return EmbeddedThirdPartyApplicationPermissionMetaData.getInstance();
            default:
                throw new RuntimeException(MessageFormat.format("EmbeddedEmbeddedThirdPartyApplicationMetaData doesn''t have nested metadata for table: {0}", nestedTable));
        }
    }
}
