
package org.blufin.sdk.embedded.metadata;
import lombok.Getter;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public final class EmbeddedUserMetaData extends AbstractMetaData {
    @Getter
    private static final EmbeddedUserMetaData instance = new EmbeddedUserMetaData();
    public static final String FIELD_ID = "id";
    public static final String FIELD_ARCHIVED = "archived";
    public static final String FIELD_SUSPENDED = "suspended";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_PASSWORD_HASH = "password_hash";
    public static final String FIELD_CREATED_DATE = "created_date";
    public static final String FIELD_TIME_ZONE = "time_zone";
    public static final String FIELD_USER_PERMISSION = "user_permission";
    private EmbeddedUserMetaData() {
        super(SchemaType.APP, "user", null, Arrays.asList("user", "user/permission"), null);
        metaData.put(FIELD_ID, new HashMap<String, Object>() {{
            put(TYPE, DataType.INT_AUTO);
            put(FLAG, Arrays.asList(FLAG_PRIMARY_KEY));
        }});
        metaData.put(FIELD_ARCHIVED, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_SUSPENDED, new HashMap<String, Object>() {{
            put(TYPE, DataType.BOOLEAN);
        }});
        metaData.put(FIELD_EMAIL, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX, FLAG_UNIQUE));
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_PASSWORD_HASH, new HashMap<String, Object>() {{
            put(TYPE, DataType.VARCHAR);
            put(FLAG, Arrays.asList(FLAG_INDEX));
            put(MAX_LENGTH, 255);
        }});
        metaData.put(FIELD_CREATED_DATE, new HashMap<String, Object>() {{
            put(TYPE, DataType.DATE);
        }});
        metaData.put(FIELD_TIME_ZONE, new HashMap<String, Object>() {{
            put(TYPE, DataType.ENUM_SYSTEM);
            put(MAX_LENGTH, 3);
            put(ENUM_NAME, "TimeZone");
            put(ENUM_VALUES, getEnumValues(TimeZone.values()));
        }});
        metaData.put(FIELD_USER_PERMISSION, new HashMap<String, Object>() {{
            put(TYPE, DataType.OBJECT);
        }});
    }
    @Override
    public AbstractMetaData getNestedMetaData(String nestedTable) {
        switch (nestedTable) {
            case "user_permission":
                return EmbeddedUserPermissionMetaData.getInstance();
            default:
                throw new RuntimeException(MessageFormat.format("EmbeddedEmbeddedUserMetaData doesn''t have nested metadata for table: {0}", nestedTable));
        }
    }
}
