
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.NestedRefiner;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.field.EmbeddedAccountField;
import org.blufin.sdk.embedded.filter.EmbeddedAccountFilter;
import org.blufin.sdk.embedded.filter.EmbeddedAccountPermissionFilter;
import org.blufin.sdk.embedded.sort.EmbeddedAccountSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedAccountRefiner extends Refiner<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> implements AbstractRefiner {
    public EmbeddedAccountRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> id() {
        return new FilterInteger<>(EmbeddedAccountFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> archived() {
        return new FilterBoolean<>(EmbeddedAccountFilter.ARCHIVED, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> suspended() {
        return new FilterBoolean<>(EmbeddedAccountFilter.SUSPENDED, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> cronEnabled() {
        return new FilterBoolean<>(EmbeddedAccountFilter.CRON_ENABLED, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> accountName() {
        return new FilterVarchar<>(EmbeddedAccountFilter.ACCOUNT_NAME, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> accountDisplayName() {
        return new FilterVarchar<>(EmbeddedAccountFilter.ACCOUNT_DISPLAY_NAME, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> dbId() {
        return new FilterInteger<>(EmbeddedAccountFilter.DB_ID, getFilters(), getOriginalRequest());
    }
    public FilterEnum<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>, TimeZone> timeZone() {
        return new FilterEnum<>(EmbeddedAccountFilter.TIME_ZONE, getFilters(), getOriginalRequest());
    }
    public EmbeddedAccountRefiner.EmbeddedAccountPermissionRefiner accountPermission() {
        return new EmbeddedAccountRefiner.EmbeddedAccountPermissionRefiner(getFilters(), getOriginalRequest());
    }
    @NestedRefiner
    public static class EmbeddedAccountPermissionRefiner extends Refiner<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> implements AbstractRefiner {
        public EmbeddedAccountPermissionRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> id() {
            return new FilterInteger<>(EmbeddedAccountPermissionFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner>> accountId() {
            return new FilterInteger<>(EmbeddedAccountPermissionFilter.ACCOUNT_ID, getFilters(), getOriginalRequest());
        }
    }
}
