
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.common.EmbeddedCron;
import org.blufin.sdk.embedded.field.EmbeddedCronField;
import org.blufin.sdk.embedded.filter.EmbeddedCronFilter;
import org.blufin.sdk.embedded.sort.EmbeddedCronSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedCronRefiner extends Refiner<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> implements AbstractRefiner {
    public EmbeddedCronRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> id() {
        return new FilterInteger<>(EmbeddedCronFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> active() {
        return new FilterBoolean<>(EmbeddedCronFilter.ACTIVE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> cronType() {
        return new FilterVarchar<>(EmbeddedCronFilter.CRON_TYPE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> scheduleMinute() {
        return new FilterVarchar<>(EmbeddedCronFilter.SCHEDULE_MINUTE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> scheduleHour() {
        return new FilterVarchar<>(EmbeddedCronFilter.SCHEDULE_HOUR, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> scheduleDay() {
        return new FilterVarchar<>(EmbeddedCronFilter.SCHEDULE_DAY, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> scheduleMonth() {
        return new FilterVarchar<>(EmbeddedCronFilter.SCHEDULE_MONTH, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> scheduleDayOfWeek() {
        return new FilterVarchar<>(EmbeddedCronFilter.SCHEDULE_DAY_OF_WEEK, getFilters(), getOriginalRequest());
    }
}
