
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.NestedRefiner;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfiguration;
import org.blufin.sdk.embedded.field.EmbeddedDbConfigurationField;
import org.blufin.sdk.embedded.filter.EmbeddedDbConfigurationFilter;
import org.blufin.sdk.embedded.filter.EmbeddedDbConfigurationPropertyFilter;
import org.blufin.sdk.embedded.sort.EmbeddedDbConfigurationSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedDbConfigurationRefiner extends Refiner<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> implements AbstractRefiner {
    public EmbeddedDbConfigurationRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> id() {
        return new FilterInteger<>(EmbeddedDbConfigurationFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> dbConfigurationName() {
        return new FilterVarchar<>(EmbeddedDbConfigurationFilter.DB_CONFIGURATION_NAME, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> poolMaxSize() {
        return new FilterInteger<>(EmbeddedDbConfigurationFilter.POOL_MAX_SIZE, getFilters(), getOriginalRequest());
    }
    public EmbeddedDbConfigurationRefiner.EmbeddedDbConfigurationPropertyRefiner dbConfigurationProperty() {
        return new EmbeddedDbConfigurationRefiner.EmbeddedDbConfigurationPropertyRefiner(getFilters(), getOriginalRequest());
    }
    @NestedRefiner
    public static class EmbeddedDbConfigurationPropertyRefiner extends Refiner<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> implements AbstractRefiner {
        public EmbeddedDbConfigurationPropertyRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> id() {
            return new FilterInteger<>(EmbeddedDbConfigurationPropertyFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> dbConfigurationId() {
            return new FilterInteger<>(EmbeddedDbConfigurationPropertyFilter.DB_CONFIGURATION_ID, getFilters(), getOriginalRequest());
        }
        public FilterVarchar<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> key() {
            return new FilterVarchar<>(EmbeddedDbConfigurationPropertyFilter.KEY, getFilters(), getOriginalRequest());
        }
        public FilterVarchar<PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner>> value() {
            return new FilterVarchar<>(EmbeddedDbConfigurationPropertyFilter.VALUE, getFilters(), getOriginalRequest());
        }
    }
}
