
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.SchemaType;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.config.EmbeddedDb;
import org.blufin.sdk.embedded.field.EmbeddedDbField;
import org.blufin.sdk.embedded.filter.EmbeddedDbFilter;
import org.blufin.sdk.embedded.sort.EmbeddedDbSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedDbRefiner extends Refiner<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> implements AbstractRefiner {
    public EmbeddedDbRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> id() {
        return new FilterInteger<>(EmbeddedDbFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> projectId() {
        return new FilterInteger<>(EmbeddedDbFilter.PROJECT_ID, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> dbName() {
        return new FilterVarchar<>(EmbeddedDbFilter.DB_NAME, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> host() {
        return new FilterVarchar<>(EmbeddedDbFilter.HOST, getFilters(), getOriginalRequest());
    }
    public FilterText<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> user() {
        return new FilterText<>(EmbeddedDbFilter.USER, getFilters(), getOriginalRequest());
    }
    public FilterText<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> password() {
        return new FilterText<>(EmbeddedDbFilter.PASSWORD, getFilters(), getOriginalRequest());
    }
    public FilterEnum<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>, Environment> environment() {
        return new FilterEnum<>(EmbeddedDbFilter.ENVIRONMENT, getFilters(), getOriginalRequest());
    }
    public FilterEnum<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>, SchemaType> schemaType() {
        return new FilterEnum<>(EmbeddedDbFilter.SCHEMA_TYPE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner>> jdbcUrl() {
        return new FilterVarchar<>(EmbeddedDbFilter.JDBC_URL, getFilters(), getOriginalRequest());
    }
}
