
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfileApi;
import org.blufin.sdk.embedded.field.EmbeddedProfileApiField;
import org.blufin.sdk.embedded.filter.EmbeddedProfileApiFilter;
import org.blufin.sdk.embedded.sort.EmbeddedProfileApiSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileApiRefiner extends Refiner<PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner>> implements AbstractRefiner {
    public EmbeddedProfileApiRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner>> id() {
        return new FilterInteger<>(EmbeddedProfileApiFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner>> profileId() {
        return new FilterInteger<>(EmbeddedProfileApiFilter.PROFILE_ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner>> commonDbId() {
        return new FilterInteger<>(EmbeddedProfileApiFilter.COMMON_DB_ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner>> commonDbConfigurationId() {
        return new FilterInteger<>(EmbeddedProfileApiFilter.COMMON_DB_CONFIGURATION_ID, getFilters(), getOriginalRequest());
    }
}
