
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.NestedRefiner;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.Environment;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfile;
import org.blufin.sdk.embedded.field.EmbeddedProfileField;
import org.blufin.sdk.embedded.filter.EmbeddedProfileApiFilter;
import org.blufin.sdk.embedded.filter.EmbeddedProfileCronFilter;
import org.blufin.sdk.embedded.filter.EmbeddedProfileFilter;
import org.blufin.sdk.embedded.filter.EmbeddedProfileWorkerFilter;
import org.blufin.sdk.embedded.sort.EmbeddedProfileSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileRefiner extends Refiner<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> implements AbstractRefiner {
    public EmbeddedProfileRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> id() {
        return new FilterInteger<>(EmbeddedProfileFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> projectId() {
        return new FilterInteger<>(EmbeddedProfileFilter.PROJECT_ID, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> profileName() {
        return new FilterVarchar<>(EmbeddedProfileFilter.PROFILE_NAME, getFilters(), getOriginalRequest());
    }
    public FilterEnum<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>, Environment> environment() {
        return new FilterEnum<>(EmbeddedProfileFilter.ENVIRONMENT, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> timezone() {
        return new FilterVarchar<>(EmbeddedProfileFilter.TIMEZONE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> messageQueueHost() {
        return new FilterVarchar<>(EmbeddedProfileFilter.MESSAGE_QUEUE_HOST, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> slackLogUrl() {
        return new FilterVarchar<>(EmbeddedProfileFilter.SLACK_LOG_URL, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> slackErrorUrl() {
        return new FilterVarchar<>(EmbeddedProfileFilter.SLACK_ERROR_URL, getFilters(), getOriginalRequest());
    }
    public FilterText<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> authorizationHeader() {
        return new FilterText<>(EmbeddedProfileFilter.AUTHORIZATION_HEADER, getFilters(), getOriginalRequest());
    }
    public EmbeddedProfileRefiner.EmbeddedProfileApiRefiner profileApi() {
        return new EmbeddedProfileRefiner.EmbeddedProfileApiRefiner(getFilters(), getOriginalRequest());
    }
    public EmbeddedProfileRefiner.EmbeddedProfileCronRefiner profileCron() {
        return new EmbeddedProfileRefiner.EmbeddedProfileCronRefiner(getFilters(), getOriginalRequest());
    }
    public EmbeddedProfileRefiner.EmbeddedProfileWorkerRefiner profileWorker() {
        return new EmbeddedProfileRefiner.EmbeddedProfileWorkerRefiner(getFilters(), getOriginalRequest());
    }
    @NestedRefiner
    public static class EmbeddedProfileApiRefiner extends Refiner<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> implements AbstractRefiner {
        public EmbeddedProfileApiRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> id() {
            return new FilterInteger<>(EmbeddedProfileApiFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> profileId() {
            return new FilterInteger<>(EmbeddedProfileApiFilter.PROFILE_ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> commonDbId() {
            return new FilterInteger<>(EmbeddedProfileApiFilter.COMMON_DB_ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> commonDbConfigurationId() {
            return new FilterInteger<>(EmbeddedProfileApiFilter.COMMON_DB_CONFIGURATION_ID, getFilters(), getOriginalRequest());
        }
    }
    @NestedRefiner
    public static class EmbeddedProfileCronRefiner extends Refiner<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> implements AbstractRefiner {
        public EmbeddedProfileCronRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> id() {
            return new FilterInteger<>(EmbeddedProfileCronFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> profileId() {
            return new FilterInteger<>(EmbeddedProfileCronFilter.PROFILE_ID, getFilters(), getOriginalRequest());
        }
    }
    @NestedRefiner
    public static class EmbeddedProfileWorkerRefiner extends Refiner<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> implements AbstractRefiner {
        public EmbeddedProfileWorkerRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> id() {
            return new FilterInteger<>(EmbeddedProfileWorkerFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner>> profileId() {
            return new FilterInteger<>(EmbeddedProfileWorkerFilter.PROFILE_ID, getFilters(), getOriginalRequest());
        }
    }
}
