
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.config.EmbeddedProject;
import org.blufin.sdk.embedded.field.EmbeddedProjectField;
import org.blufin.sdk.embedded.filter.EmbeddedProjectFilter;
import org.blufin.sdk.embedded.sort.EmbeddedProjectSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProjectRefiner extends Refiner<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> implements AbstractRefiner {
    public EmbeddedProjectRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> id() {
        return new FilterInteger<>(EmbeddedProjectFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> clientId() {
        return new FilterInteger<>(EmbeddedProjectFilter.CLIENT_ID, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> projectName() {
        return new FilterVarchar<>(EmbeddedProjectFilter.PROJECT_NAME, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> projectNamePascalCase() {
        return new FilterVarchar<>(EmbeddedProjectFilter.PROJECT_NAME_PASCAL_CASE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> projectTitle() {
        return new FilterVarchar<>(EmbeddedProjectFilter.PROJECT_TITLE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> domain() {
        return new FilterVarchar<>(EmbeddedProjectFilter.DOMAIN, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> alias() {
        return new FilterVarchar<>(EmbeddedProjectFilter.ALIAS, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> portRange() {
        return new FilterVarchar<>(EmbeddedProjectFilter.PORT_RANGE, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> encryptionKey() {
        return new FilterVarchar<>(EmbeddedProjectFilter.ENCRYPTION_KEY, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedProject, EmbeddedProjectField, EmbeddedProjectSort, EmbeddedProjectRefiner>> encryptionIv() {
        return new FilterVarchar<>(EmbeddedProjectFilter.ENCRYPTION_IV, getFilters(), getOriginalRequest());
    }
}
