
package org.blufin.sdk.embedded.refiner;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.NestedRefiner;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.base.AbstractRefiner;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.field.EmbeddedUserField;
import org.blufin.sdk.embedded.filter.EmbeddedUserFilter;
import org.blufin.sdk.embedded.filter.EmbeddedUserPermissionFilter;
import org.blufin.sdk.embedded.sort.EmbeddedUserSort;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.dynamic.*;
import org.blufin.sdk.request.PaginatedGetRequest;
import java.util.List;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedUserRefiner extends Refiner<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> implements AbstractRefiner {
    public EmbeddedUserRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner> originalRequest) {
        super(filters, originalRequest);
    }
    public FilterInteger<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> id() {
        return new FilterInteger<>(EmbeddedUserFilter.ID, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> archived() {
        return new FilterBoolean<>(EmbeddedUserFilter.ARCHIVED, getFilters(), getOriginalRequest());
    }
    public FilterBoolean<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> suspended() {
        return new FilterBoolean<>(EmbeddedUserFilter.SUSPENDED, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> email() {
        return new FilterVarchar<>(EmbeddedUserFilter.EMAIL, getFilters(), getOriginalRequest());
    }
    public FilterVarchar<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> passwordHash() {
        return new FilterVarchar<>(EmbeddedUserFilter.PASSWORD_HASH, getFilters(), getOriginalRequest());
    }
    public FilterDate<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> createdDate() {
        return new FilterDate<>(EmbeddedUserFilter.CREATED_DATE, getFilters(), getOriginalRequest());
    }
    public FilterEnum<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>, TimeZone> timeZone() {
        return new FilterEnum<>(EmbeddedUserFilter.TIME_ZONE, getFilters(), getOriginalRequest());
    }
    public EmbeddedUserRefiner.EmbeddedUserPermissionRefiner userPermission() {
        return new EmbeddedUserRefiner.EmbeddedUserPermissionRefiner(getFilters(), getOriginalRequest());
    }
    @NestedRefiner
    public static class EmbeddedUserPermissionRefiner extends Refiner<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> implements AbstractRefiner {
        public EmbeddedUserPermissionRefiner(List<Filter> filters, PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner> originalRequest) {
            super(filters, originalRequest);
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> id() {
            return new FilterInteger<>(EmbeddedUserPermissionFilter.ID, getFilters(), getOriginalRequest());
        }
        public FilterInteger<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> userId() {
            return new FilterInteger<>(EmbeddedUserPermissionFilter.USER_ID, getFilters(), getOriginalRequest());
        }
    }
}
