
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccountPermission;
import org.blufin.sdk.embedded.field.EmbeddedAccountPermissionField;
import org.blufin.sdk.embedded.metadata.EmbeddedAccountPermissionMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedAccountPermissionRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedAccountPermissionSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedAccountPermissionService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedAccountPermissionService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedAccountPermission, EmbeddedAccountPermissionField, EmbeddedAccountPermissionSort, EmbeddedAccountPermissionRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "account-permission", EmbeddedAccountPermission.class, EmbeddedAccountPermissionMetaData.getInstance(), EmbeddedAccountPermissionRefiner.class);
    }
    public IdSetGetRequest<EmbeddedAccountPermission, EmbeddedAccountPermissionField, EmbeddedAccountPermissionSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "account-permission", EmbeddedAccountPermission.class, EmbeddedAccountPermissionMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedAccountPermission, EmbeddedAccountPermissionField, EmbeddedAccountPermissionSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "account-permission", EmbeddedAccountPermission.class, EmbeddedAccountPermissionMetaData.getInstance(), new IdSet(id));
    }
}
