
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.field.EmbeddedAccountField;
import org.blufin.sdk.embedded.metadata.EmbeddedAccountMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedAccountRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedAccountSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedAccountService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedAccountService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort, EmbeddedAccountRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "account", EmbeddedAccount.class, EmbeddedAccountMetaData.getInstance(), EmbeddedAccountRefiner.class);
    }
    public IdSetGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "account", EmbeddedAccount.class, EmbeddedAccountMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedAccount, EmbeddedAccountField, EmbeddedAccountSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "account", EmbeddedAccount.class, EmbeddedAccountMetaData.getInstance(), new IdSet(id));
    }
}
