
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.common.EmbeddedCron;
import org.blufin.sdk.embedded.field.EmbeddedCronField;
import org.blufin.sdk.embedded.metadata.EmbeddedCronMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedCronRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedCronSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.request.type.AccountRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedCronService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedCronService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public AccountRequest<PaginatedGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort, EmbeddedCronRefiner>> get() {
        return new AccountRequest(apiCredentials, "cron", EmbeddedCron.class, EmbeddedCronMetaData.getInstance(), EmbeddedCronRefiner.class);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort>> get(IdSet idSet) {
        return new AccountRequest(apiCredentials, "cron", EmbeddedCron.class, EmbeddedCronMetaData.getInstance(), idSet);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedCron, EmbeddedCronField, EmbeddedCronSort>> get(int id) {
        return new AccountRequest(apiCredentials, "cron", EmbeddedCron.class, EmbeddedCronMetaData.getInstance(), new IdSet(id));
    }
}
