
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfigurationProperty;
import org.blufin.sdk.embedded.field.EmbeddedDbConfigurationPropertyField;
import org.blufin.sdk.embedded.metadata.EmbeddedDbConfigurationPropertyMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedDbConfigurationPropertyRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedDbConfigurationPropertySort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedDbConfigurationPropertyService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedDbConfigurationPropertyService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedDbConfigurationProperty, EmbeddedDbConfigurationPropertyField, EmbeddedDbConfigurationPropertySort, EmbeddedDbConfigurationPropertyRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "db-configuration-property", EmbeddedDbConfigurationProperty.class, EmbeddedDbConfigurationPropertyMetaData.getInstance(), EmbeddedDbConfigurationPropertyRefiner.class);
    }
    public IdSetGetRequest<EmbeddedDbConfigurationProperty, EmbeddedDbConfigurationPropertyField, EmbeddedDbConfigurationPropertySort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "db-configuration-property", EmbeddedDbConfigurationProperty.class, EmbeddedDbConfigurationPropertyMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedDbConfigurationProperty, EmbeddedDbConfigurationPropertyField, EmbeddedDbConfigurationPropertySort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "db-configuration-property", EmbeddedDbConfigurationProperty.class, EmbeddedDbConfigurationPropertyMetaData.getInstance(), new IdSet(id));
    }
}
