
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfiguration;
import org.blufin.sdk.embedded.field.EmbeddedDbConfigurationField;
import org.blufin.sdk.embedded.metadata.EmbeddedDbConfigurationMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedDbConfigurationRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedDbConfigurationSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedDbConfigurationService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedDbConfigurationService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort, EmbeddedDbConfigurationRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "db-configuration", EmbeddedDbConfiguration.class, EmbeddedDbConfigurationMetaData.getInstance(), EmbeddedDbConfigurationRefiner.class);
    }
    public IdSetGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "db-configuration", EmbeddedDbConfiguration.class, EmbeddedDbConfigurationMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedDbConfiguration, EmbeddedDbConfigurationField, EmbeddedDbConfigurationSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "db-configuration", EmbeddedDbConfiguration.class, EmbeddedDbConfigurationMetaData.getInstance(), new IdSet(id));
    }
}
