
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedDb;
import org.blufin.sdk.embedded.field.EmbeddedDbField;
import org.blufin.sdk.embedded.metadata.EmbeddedDbMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedDbRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedDbSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedDbService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedDbService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort, EmbeddedDbRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "db", EmbeddedDb.class, EmbeddedDbMetaData.getInstance(), EmbeddedDbRefiner.class);
    }
    public IdSetGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "db", EmbeddedDb.class, EmbeddedDbMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedDb, EmbeddedDbField, EmbeddedDbSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "db", EmbeddedDb.class, EmbeddedDbMetaData.getInstance(), new IdSet(id));
    }
}
