
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfileApi;
import org.blufin.sdk.embedded.field.EmbeddedProfileApiField;
import org.blufin.sdk.embedded.metadata.EmbeddedProfileApiMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedProfileApiRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedProfileApiSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileApiService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedProfileApiService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort, EmbeddedProfileApiRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "profile-api", EmbeddedProfileApi.class, EmbeddedProfileApiMetaData.getInstance(), EmbeddedProfileApiRefiner.class);
    }
    public IdSetGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "profile-api", EmbeddedProfileApi.class, EmbeddedProfileApiMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedProfileApi, EmbeddedProfileApiField, EmbeddedProfileApiSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "profile-api", EmbeddedProfileApi.class, EmbeddedProfileApiMetaData.getInstance(), new IdSet(id));
    }
}
