
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfileCron;
import org.blufin.sdk.embedded.field.EmbeddedProfileCronField;
import org.blufin.sdk.embedded.metadata.EmbeddedProfileCronMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedProfileCronRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedProfileCronSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileCronService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedProfileCronService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedProfileCron, EmbeddedProfileCronField, EmbeddedProfileCronSort, EmbeddedProfileCronRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "profile-cron", EmbeddedProfileCron.class, EmbeddedProfileCronMetaData.getInstance(), EmbeddedProfileCronRefiner.class);
    }
    public IdSetGetRequest<EmbeddedProfileCron, EmbeddedProfileCronField, EmbeddedProfileCronSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "profile-cron", EmbeddedProfileCron.class, EmbeddedProfileCronMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedProfileCron, EmbeddedProfileCronField, EmbeddedProfileCronSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "profile-cron", EmbeddedProfileCron.class, EmbeddedProfileCronMetaData.getInstance(), new IdSet(id));
    }
}
