
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfile;
import org.blufin.sdk.embedded.field.EmbeddedProfileField;
import org.blufin.sdk.embedded.metadata.EmbeddedProfileMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedProfileRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedProfileSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedProfileService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort, EmbeddedProfileRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "profile", EmbeddedProfile.class, EmbeddedProfileMetaData.getInstance(), EmbeddedProfileRefiner.class);
    }
    public IdSetGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "profile", EmbeddedProfile.class, EmbeddedProfileMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedProfile, EmbeddedProfileField, EmbeddedProfileSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "profile", EmbeddedProfile.class, EmbeddedProfileMetaData.getInstance(), new IdSet(id));
    }
}
