
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.config.EmbeddedProfileWorker;
import org.blufin.sdk.embedded.field.EmbeddedProfileWorkerField;
import org.blufin.sdk.embedded.metadata.EmbeddedProfileWorkerMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedProfileWorkerRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedProfileWorkerSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedProfileWorkerService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedProfileWorkerService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedProfileWorker, EmbeddedProfileWorkerField, EmbeddedProfileWorkerSort, EmbeddedProfileWorkerRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "profile-worker", EmbeddedProfileWorker.class, EmbeddedProfileWorkerMetaData.getInstance(), EmbeddedProfileWorkerRefiner.class);
    }
    public IdSetGetRequest<EmbeddedProfileWorker, EmbeddedProfileWorkerField, EmbeddedProfileWorkerSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "profile-worker", EmbeddedProfileWorker.class, EmbeddedProfileWorkerMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedProfileWorker, EmbeddedProfileWorkerField, EmbeddedProfileWorkerSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "profile-worker", EmbeddedProfileWorker.class, EmbeddedProfileWorkerMetaData.getInstance(), new IdSet(id));
    }
}
