
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;
import org.blufin.sdk.embedded.field.EmbeddedThirdPartyApplicationField;
import org.blufin.sdk.embedded.metadata.EmbeddedThirdPartyApplicationMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedThirdPartyApplicationRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedThirdPartyApplicationSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedThirdPartyApplicationService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedThirdPartyApplicationService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public PaginatedGetRequest<EmbeddedThirdPartyApplication, EmbeddedThirdPartyApplicationField, EmbeddedThirdPartyApplicationSort, EmbeddedThirdPartyApplicationRefiner> get() {
        return new PaginatedGetRequest<>(apiCredentials, "third-party-application", EmbeddedThirdPartyApplication.class, EmbeddedThirdPartyApplicationMetaData.getInstance(), EmbeddedThirdPartyApplicationRefiner.class);
    }
    public IdSetGetRequest<EmbeddedThirdPartyApplication, EmbeddedThirdPartyApplicationField, EmbeddedThirdPartyApplicationSort> get(IdSet idSet) {
        return new IdSetGetRequest<>(apiCredentials, "third-party-application", EmbeddedThirdPartyApplication.class, EmbeddedThirdPartyApplicationMetaData.getInstance(), idSet);
    }
    public IdSetGetRequest<EmbeddedThirdPartyApplication, EmbeddedThirdPartyApplicationField, EmbeddedThirdPartyApplicationSort> get(int id) {
        return new IdSetGetRequest<>(apiCredentials, "third-party-application", EmbeddedThirdPartyApplication.class, EmbeddedThirdPartyApplicationMetaData.getInstance(), new IdSet(id));
    }
}
