
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.app.EmbeddedUserPermission;
import org.blufin.sdk.embedded.field.EmbeddedUserPermissionField;
import org.blufin.sdk.embedded.metadata.EmbeddedUserPermissionMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedUserPermissionRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedUserPermissionSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.request.type.AccountRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedUserPermissionService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedUserPermissionService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public AccountRequest<PaginatedGetRequest<EmbeddedUserPermission, EmbeddedUserPermissionField, EmbeddedUserPermissionSort, EmbeddedUserPermissionRefiner>> get() {
        return new AccountRequest(apiCredentials, "user-permission", EmbeddedUserPermission.class, EmbeddedUserPermissionMetaData.getInstance(), EmbeddedUserPermissionRefiner.class);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedUserPermission, EmbeddedUserPermissionField, EmbeddedUserPermissionSort>> get(IdSet idSet) {
        return new AccountRequest(apiCredentials, "user-permission", EmbeddedUserPermission.class, EmbeddedUserPermissionMetaData.getInstance(), idSet);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedUserPermission, EmbeddedUserPermissionField, EmbeddedUserPermissionSort>> get(int id) {
        return new AccountRequest(apiCredentials, "user-permission", EmbeddedUserPermission.class, EmbeddedUserPermissionMetaData.getInstance(), new IdSet(id));
    }
}
