
package org.blufin.sdk.embedded.service;
import org.blufin.base.annotations.AutoGenerated;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.annotations.helper.ON;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractService;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.field.EmbeddedUserField;
import org.blufin.sdk.embedded.metadata.EmbeddedUserMetaData;
import org.blufin.sdk.embedded.refiner.EmbeddedUserRefiner;
import org.blufin.sdk.embedded.sort.EmbeddedUserSort;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.request.type.AccountRequest;
import org.blufin.sdk.service.credentials.ApiCredentials;
@TestNotRequired
@AutoGenerated(ON.EVERY_RUN)
public class EmbeddedUserService implements AbstractService {
    private final ApiCredentials apiCredentials;
    public EmbeddedUserService(ApiCredentials apiCredentials) {
        this.apiCredentials = apiCredentials;
    }
    public AccountRequest<PaginatedGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort, EmbeddedUserRefiner>> get() {
        return new AccountRequest(apiCredentials, "user", EmbeddedUser.class, EmbeddedUserMetaData.getInstance(), EmbeddedUserRefiner.class);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort>> get(IdSet idSet) {
        return new AccountRequest(apiCredentials, "user", EmbeddedUser.class, EmbeddedUserMetaData.getInstance(), idSet);
    }
    public AccountRequest<IdSetGetRequest<EmbeddedUser, EmbeddedUserField, EmbeddedUserSort>> get(int id) {
        return new AccountRequest(apiCredentials, "user", EmbeddedUser.class, EmbeddedUserMetaData.getInstance(), new IdSet(id));
    }
}
