
package org.blufin.sdk.filters;
import org.blufin.base.constants.Constants;
import lombok.Getter;
import lombok.Setter;
@Getter
public class Filter {
    private final FilterType filterType;
    private final String fieldName;
    @Setter
    private Modifier modifier;
    @Setter
    private String primaryValue = Constants.EMPTY_STRING;
    @Setter
    private String secondaryValue;
    public Filter(FilterType filterType, String fieldName) {
        this.filterType = filterType;
        this.fieldName = fieldName;
    }
    public Filter(FilterType filterType, String fieldName, Modifier modifier, String primaryValue) {
        this.filterType = filterType;
        this.fieldName = fieldName;
        this.modifier = modifier;
        this.primaryValue = primaryValue;
    }
    public Filter(FilterType filterType, String fieldName, Modifier modifier, String primaryValue, String secondaryValue) {
        this.filterType = filterType;
        this.fieldName = fieldName;
        this.modifier = modifier;
        this.primaryValue = primaryValue;
        this.secondaryValue = secondaryValue;
    }
}
